/*--------------------------------------------------------------------------*/
/*               The Opus Computer-Based Conversation System                */
/*       (c) Copyright 1986, Wynn Wagner III, All Rights Reserved           */
/* This source code is proprietary and confidential.  Not for distribution. */
/*--------------------------------------------------------------------------*/

#ifndef BINKLEY
#include "bbs.h"
#else
#include "xfer.h"
#include <stdio.h>
extern int cur_baud;
#endif   
   
/*--------------------------------------------------------------------------*/
/* THROUGHPUT                                                               */
/* Print throughput message at end of transfer                              */
/*--------------------------------------------------------------------------*/
void pascal throughput(opt, bytes)
   int            opt;
   unsigned long  bytes;
   begin
      static byte         *scrn     = "-CPS: %lu  Efficiency: %lu%%";
      static unsigned long started  = 0L;
      static unsigned long cps;

      if (!opt)   started  = time(NULL);
      else if (started)
         begin
#ifndef	BINKLEY
            if (opt==0xff) mdm_printf(scrn,cps,started); /* F)ile S)tats */
            else
#endif
               begin
                  cps      = bytes / (time(NULL)-started);
                  started  = (cps * 1000L) / ((long )cur_baud);
                  status_line(scrn,cps,started);
               end
         end

   end /* throughput */

/* END OF FILE: f_time.c */

